<?php

declare(strict_types=1);

namespace IssetBV\Message\Core\Message\Decoder;

use IssetBV\Message\Core\Message\Decoder\Exception\DecoderNotFoundException;
use IssetBV\Message\Core\Message\MessageInterface;

class DecoderContainer implements DecoderContainerInterface
{
    /**
     * @var DecoderInterface[]
     */
    private $decoders = [];

    public function get(string $type, string $version): DecoderInterface
    {
        foreach ($this->decoders as $decoder) {
            if ($decoder::decodes($type, $version)) {
                return $decoder;
            }
        }

        throw new DecoderNotFoundException('No decoder found for type: ' . $type . ' version: ' . $version);
    }

    public function add(DecoderInterface $decoder)
    {
        $this->decoders[] = $decoder;
    }

    public function decode(string $type, string $version, string $message): MessageInterface
    {
        return $this->get($type, $version)->decode($version, $message);
    }
}
