<?php

declare(strict_types=1);

namespace IssetBV\Message\Core\Connection;

class ConnectionFactory implements ConnectionFactoryInterface
{
    const TAG = 'issetbv_message_connection';
    /**
     * @var ConnectionInterface[]
     */
    private $connections = [];

    public function getForName(string $name): ConnectionInterface
    {
        if (!$this->hasName($name)) {
            throw new \LogicException('Name \'' . $name . '\' doesn\'t exists');
        }

        return $this->connections[$name];
    }

    public function add(ConnectionInterface $connection)
    {
        $name = $connection->getName();
        if ($this->hasName($name)) {
            throw new \LogicException('Name \'' . $name . '\' all ready exists');
        }

        $this->connections[$name] = $connection;
    }

    private function hasName(string $name): bool
    {
        return array_key_exists($name, $this->connections);
    }
}
