<?php

declare(strict_types=1);

namespace IssetBV\Message\Core;

use IssetBV\Message\Core\Exception\MessagePublisherHandlerMissingException;

class MessagePublisher implements MessagePublisherInterface
{
    /**
     * @var MessagePublisherHandler[]
     */
    private $messagePublishers = [];

    public function publish(MessageInterface $message)
    {
        foreach ($this->messagePublishers as $messagePublisher) {
            if ($messagePublisher->handles($message)) {
                $messagePublisher->publish($message);
                return;
            }
        }
        throw new MessagePublisherHandlerMissingException('Handler missing exception type:' . $message->getType() . ' version ' . $message->getVersion());
    }

    public function add(MessagePublisherHandlerInterface $messagePublisherHandler)
    {
        $this->messagePublishers[] = $messagePublisherHandler;

    }
}