<?php

declare(strict_types=1);

namespace IssetBV\Message\Core;

use IssetBV\Message\Core\Exception\MessageConsumerMissingException;

class MessageConsumerContainer implements MessageConsumerContainerInterface
{
    /**
     * @var MessageConsumerHandlerInterface[]
     */
    private $messageConsumerHandlers = [];

    public function consume(string $name)
    {
        if (!array_key_exists($name, $this->messageConsumerHandlers)) {
            throw new MessageConsumerMissingException('Missing consumer: ', $name);
        }
        $this->messageConsumerHandlers[$name]->handleNext();
    }

    public function add(MessageConsumerHandlerInterface $messageConsumerHandler)
    {
        $this->messageConsumerHandlers[$messageConsumerHandler->getName()] = $messageConsumerHandler;
    }
}