<?php

namespace Media\Framework\Translation;

class TableRow implements TableRowInterface
{

    private $command;
    private $position;
    private $setting;

    public function __construct(\Media\Framework\Transcode\Setting\SettingInterface $setting, TableFieldInterface $interface)
    {
        if ($interface->getQuote()) {
            $this->command = $interface->getTo() . '"' . $setting->getValue() . '"';
        } else {
            $this->command  = $interface->getTo() . $setting->getValue();
        }
        $this->setting  = $setting->getName();
        $this->position = $interface->getPosition();
    }

    public function getPosition()
    {
        return $this->position;
    }

    public function getCommand()
    {
        return $this->command;
    }

    public function getSetting()
    {
        return $this->setting;
    }

}