<?php

namespace Media\Framework\Translation;

class Table implements TableInterface
{

    protected $rows = array();

    public function addTranslation($type, TableFieldInterface $tableField)
    {
        if (!isset($this->rows[$type])) {
            $this->rows[$type] = array();
        }
        $this->rows[$type][$tableField->getFrom()] = $tableField;
        return $this;
    }

    public function hasTranslation($type, $setting)
    {
        return isset($this->rows[$type][$setting]);
    }

    public function translate(\Media\Framework\Transcode\Setting\SettingInterface $setting)
    {
        if (!isset($this->rows[$setting->getType()][$setting->getName()])) {
            throw new \Media\Framework\Exception\Translation\TranslationRowNotFound();
        }


        return new TableRow($setting, $this->rows[$setting->getType()][$setting->getName()]);
    }

}