<?php

namespace Media\Framework\Transcode\Driver;

class Driver implements DriverInterface
{

    protected $baseCommand;
    protected $builder;
    protected $translationTable;

    public function __construct(\Media\Framework\Translation\TableInterface $translationTable, $baseCommand)
    {
        $this->baseCommand      = $baseCommand;
        $this->builder          = new \Media\Framework\Command\Builder($translationTable);
        $this->translationTable = $translationTable;
    }

    public function getTranslationTable()
    {
        return $this->translationTable;
    }

    public function build(\Media\Framework\Transcode\Job $job)
    {
        foreach ($job->getSettings() as $settings) {

            foreach ($settings as $setting) {
                $this->builder->addItem($setting);
            }
        }

        return $this->baseCommand . $this->builder->build();
    }

}