<?php

namespace Media\Framework\Command;

class Builder
{

    /**
     *
     * @var \Media\Framework\Translation\TableInterface
     */
    protected $translationTable;
    protected $parts = array();
    protected $glue = ' ';

    public function __construct(\Media\Framework\Translation\TableInterface $translationTable)
    {
        $this->translationTable = $translationTable;
    }

    public function addItem(\Media\Framework\Transcode\Setting\SettingInterface $setting)
    {
        $row                                = $this->translationTable->translate($setting);
        $this->parts[$row->getPosition()][] = $row;
    }

    public function build()
    {
        $return = '';
        ksort($this->parts);
        foreach ($this->parts as $parts) {
            foreach ($parts as $part) {
                $return .= $this->glue . $part->getCommand();
            }
        }
        return ltrim($return, $this->glue);
    }

}