<?php

namespace Media\FFMpeg\V2\Translation;

use Media\Framework\Translation\TableField;

class Table extends \Media\Framework\Translation\Table
{

    public function __construct()
    {
        $this
                ->addTranslation('file', new TableField('overwrite-ouput', '-y', 50))
                ->addTranslation('file', new TableField('input', '-i ', 100))
                ->addTranslation('file', new TableField('output', '', 9000))
                ->addTranslation('video', new TableField('codec', '-vcodec ', 201))
                ->addTranslation('video', new TableField('preset', '-preset ', 202))
                ->addTranslation('video', new TableField('threads', '-threads ', 203))
                ->addTranslation('video', new TableField('bitrate-minimum', '-vminrate ', 211))
                ->addTranslation('video', new TableField('bitrate-average', '-b:v ', 212))
                ->addTranslation('video', new TableField('bitrate-maximum', '-vmaxrate ', 212))
                ->addTranslation('video', new TableField('buffersize', '-bufsize ', 213))
                ->addTranslation('video', new TableField('resolution', '-s ', 220))
                ->addTranslation('video', new TableField('profile', '-profile:v ', 230))
                ->addTranslation('video', new TableField('profile-level', '-level ', 231))
                ->addTranslation('video', new TableField('pixel-format', '-pix_fmt ', 280))
                ->addTranslation('audio', new TableField('codec', '-acodec ', 1100))
                ->addTranslation('audio', new TableField('allow-experimental', '-ac 1 -strict -2', 1900))
                ->addTranslation('subtitle', new TableField('input', '-vf subtitles=', 2001, true));
        ;

        //subtitle
    }

}
