<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Service\Mail;

interface MailInterface
{
    /**
     * @return AddressInterface
     */
    public function getFrom(): AddressInterface;

    /**
     * @return AddressInterface[]
     */
    public function getTo(): array;

    /**
     * @return AddressInterface[]
     */
    public function getCc(): array;

    /**
     * @return AddressInterface[]
     */
    public function getBcc(): array;

    /**
     * @return AttachmentInterface[]
     */
    public function getAttachments(): array;

    /**
     * @return string
     */
    public function getSubject(): string;

    /**
     * @return string|null
     */
    public function getBodyHtml();

    /**
     * @return string|null
     */
    public function getBodyText();
}
