<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Service\Mail\Center;

use IssetBV\MailBundle\Service\Mail\Center\Exception\MailNotFoundException;
use IssetBV\MailBundle\Service\Mail\MailInterface;

interface MailCenterInterface
{
    /**
     * @param MailInterface $mail
     *
     * @return string
     */
    public function add(MailInterface $mail): string;

    /**
     * @param string $uuid
     *
     * @throws MailNotFoundException
     *
     * @return MailInterface
     */
    public function get(string $uuid): MailInterface;
}
