<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\DependencyInjection;

use IssetBV\MailBundle\Service\Mail\Center\MailCenterInterface;
use IssetBV\MailBundle\Service\Mail\Center\Mailer\MailerInterface;
use IssetBV\MailBundle\Service\Mail\Center\Mailer\Swift\MessageListener;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVMailExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $container->setAlias(MailerInterface::class, $config['mailer']);
        $container->setAlias(MailCenterInterface::class, $config['mail_center']);

        if (null !== $config['swiftmailer_listener']) {
            $definition = $container->getDefinition(MessageListener::class);
            $definition->addTag($config['swiftmailer_listener']);
        }
    }
}
