<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\DependencyInjection;

use IssetBV\MailBundle\Service\Mail\Center\Doctrine\MailCenterDoctrine;
use IssetBV\MailBundle\Service\Mail\Center\Mailer\Swift\SwiftMailer;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('isset_bv_mail');
        $rootNode
            ->children()
            ->scalarNode('mailer')->defaultValue(SwiftMailer::class)->end()
            ->scalarNode('mail_center')->defaultValue(MailCenterDoctrine::class)->end()
            ->scalarNode('swiftmailer_listener')->defaultValue('swiftmailer.default.plugin')->end()
            ->end();

        return $treeBuilder;
    }
}
