<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Service\Mail\Center\Mailer;

use IssetBV\MailBundle\Service\Mail\AddressInterface;
use IssetBV\MailBundle\Service\Mail\MailInterface;

interface MailChangeableInterface
{
    const PENDING = 'pending';
    const SENT = 'sent';
    const FAILED = 'failed';

    public function getMessageId(): string;

    public function getUUID(): string;

    public function getMail(): MailInterface;

    public function changeState(AddressInterface $address, string $state);
}
