<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Service\Mail\Center\Doctrine;

use Doctrine\Common\Persistence\ObjectRepository;
use IssetBV\MailBundle\Entity\MailAddress;
use IssetBV\MailBundle\Entity\MailAddressState;
use IssetBV\MailBundle\Repository\MailAddressRepository;
use IssetBV\MailBundle\Repository\MailAddressStateRepository;

/**
 * Class MailStateChanger.
 */
class MailAddressStateChanger
{
    /**
     * @var ObjectRepository
     */
    private $mailAddressRepository;
    /**
     * @var ObjectRepository
     */
    private $mailAddressStateRepository;

    private $cache = [];

    public function __construct(MailAddressRepository $mailAddressRepository, MailAddressStateRepository $mailAddressStateRepository)
    {
        $this->mailAddressRepository = $mailAddressRepository;
        $this->mailAddressStateRepository = $mailAddressStateRepository;
    }

    public function setPending(string $messageId, array $emails)
    {
        $mailAddresses = $this->mailAddressRepository->fetchByMessageIdAndEmails($messageId, $emails);
        $this->setStates($mailAddresses, MailAddressState::PENDING);
    }

    public function setFailed(string $messageId, array $emails)
    {
        $mailAddresses = $this->mailAddressRepository->fetchByMessageIdAndEmails($messageId, $emails);
        $this->setStates($mailAddresses, MailAddressState::FAILED);
    }

    public function setSent(string $messageId, array $emails)
    {
        $mailAddresses = $this->mailAddressRepository->fetchByMessageIdAndEmails($messageId, $emails);
        $this->setStates($mailAddresses, MailAddressState::SENT);
    }

    public function setStates(array $mailAddresses, string $state)
    {
        $stateEntity = $this->mailAddressStateRepository->fetchByState($state);
        foreach ($mailAddresses as $mailAddress) {
            $mailAddress->setState($stateEntity);
        }
    }

    public function setState(MailAddress $address, string $state)
    {
        $stateEntity = $this->mailAddressStateRepository->fetchByState($state);
        $address->setState($stateEntity);
    }
}
