<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use IssetBV\MailBundle\Service\Mail\AttachmentInterface;

/**
 * @ORM\Entity
 * @ORM\Table(name="isset_bv_mail_attachments")
 */
class MailAttachment implements AttachmentInterface
{
    /**
     * @var int
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;
    /**
     * @var Mail
     * @ORM\ManyToOne(targetEntity="Mail", inversedBy="attachments")
     * @ORM\JoinColumn(nullable=false, onDelete="cascade")
     */
    private $mail;
    /**
     * @var string
     * @ORM\Column(type="string", nullable=false)
     */
    private $file;
    /**
     * @var string|null
     * @ORM\Column(type="string", nullable=true)
     */
    private $name;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return Mail
     */
    public function getMail()
    {
        return $this->mail;
    }

    /**
     * @param Mail $mail
     */
    public function setMail(Mail $mail)
    {
        $this->mail = $mail;
    }

    /**
     * @return string
     */
    public function getFile()
    {
        return $this->file;
    }

    /**
     * @param string $file
     */
    public function setFile(string $file)
    {
        $this->file = $file;
    }

    /**
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name = null)
    {
        $this->name = $name;
    }

    public function getFilePath(): string
    {
        return $this->getFile();
    }
}
