<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use IssetBV\MailBundle\Service\Mail\AddressInterface;

/**
 * @ORM\Entity(repositoryClass="IssetBV\MailBundle\Repository\MailAddressRepository")
 * @ORM\Table(name="isset_bv_mail_addresses")
 */
class MailAddress implements AddressInterface
{
    /**
     * @var int
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;
    /**
     * @var Mail
     * @ORM\ManyToOne(targetEntity="Mail", inversedBy="addresses")
     * @ORM\JoinColumn(nullable=false, onDelete="cascade")
     */
    private $mail;
    /**
     * @var MailAddressType
     * @ORM\ManyToOne(targetEntity="MailAddressType")
     * @ORM\JoinColumn(nullable=false, referencedColumnName="type")
     */
    private $type;
    /**
     * @var MailAddressState
     * @ORM\ManyToOne(targetEntity="MailAddressState")
     * @ORM\JoinColumn(nullable=false, referencedColumnName="state")
     */
    private $state;
    /**
     * @var string
     * @ORM\Column(type="string", nullable=false)
     */
    private $email;
    /**
     * @var string
     * @ORM\Column(type="string", nullable=true)
     */
    private $name;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return Mail
     */
    public function getMail(): Mail
    {
        return $this->mail;
    }

    /**
     * @param Mail $mail
     */
    public function setMail(Mail $mail)
    {
        $this->mail = $mail;
    }

    /**
     * @return MailAddressType
     */
    public function getType(): MailAddressType
    {
        return $this->type;
    }

    /**
     * @param MailAddressType $type
     */
    public function setType(MailAddressType $type)
    {
        $this->type = $type;
    }

    /**
     * @return MailAddressState
     */
    public function getState(): MailAddressState
    {
        return $this->state;
    }

    /**
     * @param MailAddressState $state
     */
    public function setState(MailAddressState $state)
    {
        $this->state = $state;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail(string $email)
    {
        $this->email = $email;
    }

    /**
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name = null)
    {
        $this->name = $name;
    }
}
