<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MailBundle\Entity\Mail;

class MailRepository extends EntityRepository
{
    /**
     * @param string $uuid
     *
     * @return Mail|null
     */
    public function fetchByUUID(string $uuid)
    {
        $mail = $this->findOneBy(['uuid' => $uuid]);

        return $mail instanceof Mail ? $mail : null;
    }
}
