<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="IssetBV\MailBundle\Repository\MailAddressTypeRepository")
 * @ORM\Table(name="isset_bv_mail_address_types")
 */
class MailAddressType
{
    const CC = 'cc';
    const BCC = 'bcc';
    const TO = 'to';

    /**
     * @var string
     * @ORM\Id
     * @ORM\Column(type="string")
     */
    private $type;

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType(string $type)
    {
        $this->type = $type;
    }
}
