<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Service\Mail;

class Mail implements MailInterface
{
    /**
     * @var AddressInterface
     */
    private $from;
    /**
     * @var AddressInterface[]
     */
    private $to = [];
    /**
     * @var AddressInterface[]
     */
    private $cc = [];
    /**
     * @var AddressInterface[]
     */
    private $bcc = [];
    /**
     * @var AttachmentInterface[]
     */
    private $attachments = [];
    /**
     * @var string
     */
    private $subject;
    /**
     * @var string
     */
    private $bodyHtml;
    /**
     * @var string
     */
    private $bodyText;

    public function __construct(string $subject, string $fromEmail, string $fromName = null)
    {
        $this->subject = $subject;
        $this->setFrom($fromEmail, $fromName);
    }

    public function setFrom(string $email, string $name = null)
    {
        $this->from = new Address($email, $name);
    }

    public function getFrom(): AddressInterface
    {
        return $this->from;
    }

    public function addTo(string $email, $name = null)
    {
        $this->to[] = new Address($email, $name);
    }

    /**
     * @return AddressInterface[]
     */
    public function getTo(): array
    {
        return $this->to;
    }

    public function addCc(string $email, $name = null)
    {
        $this->cc[] = new Address($email, $name);
    }

    /**
     * @return AddressInterface[]
     */
    public function getCc(): array
    {
        return $this->cc;
    }

    public function addBcc(string $email, $name = null)
    {
        $this->bcc[] = new Address($email, $name);
    }

    /**
     * @return AddressInterface[]
     */
    public function getBcc(): array
    {
        return $this->bcc;
    }

    /**
     * @param string $subject
     */
    public function setSubject(string $subject)
    {
        $this->subject = $subject;
    }

    /**
     * @return string
     */
    public function getSubject(): string
    {
        return $this->subject;
    }

    /**
     * @param string $bodyHtml
     */
    public function setBodyHtml(string $bodyHtml)
    {
        $this->bodyHtml = $bodyHtml;
    }

    /**
     * @return string|null
     */
    public function getBodyHtml()
    {
        return $this->bodyHtml;
    }

    /**
     * @param string $bodyText
     */
    public function setBodyText(string $bodyText)
    {
        $this->bodyText = $bodyText;
    }

    /**
     * @return string|null
     */
    public function getBodyText()
    {
        return $this->bodyText;
    }

    /**
     * @return AttachmentInterface[]
     */
    public function getAttachments(): array
    {
        return $this->attachments;
    }

    public function addAttachment(string $filePath, string $fileName = null)
    {
        $this->attachments[] = new Attachment($filePath, $fileName);
    }
}
