<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Service\Mail\Center\Doctrine;

use IssetBV\MailBundle\Entity\Mail;
use IssetBV\MailBundle\Service\Mail\Address;
use IssetBV\MailBundle\Service\Mail\AddressInterface;
use IssetBV\MailBundle\Service\Mail\AttachmentInterface;
use IssetBV\MailBundle\Service\Mail\MailInterface;

class MailProxy implements MailInterface
{
    /**
     * @var Mail
     */
    private $mail;

    public function __construct(Mail $mail)
    {
        $this->mail = $mail;
    }

    /**
     * @return AddressInterface
     */
    public function getFrom(): AddressInterface
    {
        return new Address($this->mail->getFrom(), $this->mail->getFromName());
    }

    /**
     * @return AddressInterface[]
     */
    public function getTo(): array
    {
        return $this->mail->getTo();
    }

    /**
     * @return AddressInterface[]
     */
    public function getCc(): array
    {
        return $this->mail->getCc();
    }

    /**
     * @return AddressInterface[]
     */
    public function getBcc(): array
    {
        return $this->mail->getBcc();
    }

    /**
     * @return AttachmentInterface[]
     */
    public function getAttachments(): array
    {
        return $this->mail->getAttachments()->toArray();
    }

    /**
     * @return string
     */
    public function getSubject(): string
    {
        return $this->mail->getSubject();
    }

    /**
     * @return string|null
     */
    public function getBodyHtml()
    {
        return $this->mail->getBodyHtml();
    }

    /**
     * @return string|null
     */
    public function getBodyText()
    {
        return $this->mail->getBody();
    }
}
