<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MailBundle\Entity\MailAddressType;

class MailAddressTypeRepository extends EntityRepository
{
    public function fetchByType(string $type): MailAddressType
    {
        $entity = $this->find($type);

        if (!($entity instanceof MailAddressType)) {
            throw new \LogicException('type not found');
        }

        return $entity;
    }
}
