<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="IssetBV\MailBundle\Repository\MailAddressStateRepository")
 * @ORM\Table(name="isset_bv_mail_address_states")
 */
class MailAddressState
{
    const PENDING = 'pending';
    const SENT = 'sent';
    const FAILED = 'failed';

    /**
     * @var string
     * @ORM\Id
     * @ORM\Column(type="string")
     */
    private $state;

    /**
     * @return string
     */
    public function getState(): string
    {
        return $this->state;
    }

    /**
     * @param string $state
     */
    public function setState(string $state)
    {
        $this->state = $state;
    }
}
