<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Service\Mail;

class Attachment implements AttachmentInterface
{
    /**
     * @var string
     */
    private $filePath;
    /**
     * @var string
     */
    private $name;

    /**
     * Attachment constructor.
     *
     * @param string $filePath
     * @param string|null $name
     */
    public function __construct(string $filePath, string $name = null)
    {
        $this->filePath = $filePath;
        $this->name = $name;
    }

    public function getFilePath(): string
    {
        return $this->filePath;
    }

    public function getName()
    {
        return $this->name;
    }
}
