<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MailBundle\Entity\MailAddressState;

class MailAddressStateRepository extends EntityRepository
{
    /**
     * @var MailAddressState[]
     */
    private $cache = [];

    public function fetchByState(string $state): MailAddressState
    {
        if (array_key_exists($state, $this->cache)) {
            return $this->cache[$state];
        }

        $entity = $this->find($state);
        if (!($entity instanceof MailAddressState)) {
            throw new \LogicException('state not found');
        }

        return $this->cache[$state] = $entity;
    }
}
