<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Service\Mail\Center\Doctrine;

use IssetBV\MailBundle\Entity\Mail;
use IssetBV\MailBundle\Entity\MailAddress;
use IssetBV\MailBundle\Entity\MailAddressState;
use IssetBV\MailBundle\Entity\MailAddressType;
use IssetBV\MailBundle\Repository\MailAddressStateRepository;
use IssetBV\MailBundle\Repository\MailAddressTypeRepository;
use IssetBV\MailBundle\Service\Mail\MailInterface;

class MailToEntityConverter
{
    /**
     * @var MailAddressStateRepository
     */
    private $mailAddressStateRepository;
    /**
     * @var MailAddressTypeRepository
     */
    private $mailAddressTypeRepository;

    public function __construct(
        MailAddressStateRepository $mailAddressStateRepository,
        MailAddressTypeRepository $mailAddressTypeRepository
    ) {
        $this->mailAddressStateRepository = $mailAddressStateRepository;
        $this->mailAddressTypeRepository = $mailAddressTypeRepository;
    }

    public function convert(MailInterface $mail): Mail
    {
        $mailEntity = new Mail();
        $mailEntity->setBody($mail->getBodyText());
        $mailEntity->setBodyHtml($mail->getBodyHtml());
        $mailEntity->setFrom($mail->getFrom()->getEmail());
        $mailEntity->setFromName($mail->getFrom()->getName());
        $mailEntity->setSubject($mail->getSubject());

        $this->convertAddresses($mail->getTo(), $mailEntity, MailAddressType::TO);
        $this->convertAddresses($mail->getBcc(), $mailEntity, MailAddressType::BCC);
        $this->convertAddresses($mail->getCc(), $mailEntity, MailAddressType::CC);

        foreach ($mail->getAttachments() as $attachment) {
            $mailEntity->addAttachment($attachment->getFilePath(), $attachment->getName());
        }

        return $mailEntity;
    }

    private function convertAddresses(array $addresses, Mail $mailEntity, string $typeName)
    {
        $type = $this->mailAddressTypeRepository->fetchByType($typeName);
        $pending = $this->mailAddressStateRepository->fetchByState(MailAddressState::PENDING);
        foreach ($addresses as $address) {
            $mailAddress = new MailAddress();
            $mailAddress->setType($type);
            $mailAddress->setEmail($address->getEmail());
            $mailAddress->setName($address->getName());
            $mailAddress->setState($pending);
            $mailEntity->addAddress($mailAddress);
        }
    }
}
