<?php

declare(strict_types=1);

namespace IssetBV\MailBundle\Service\Mail\Center\Doctrine;

use IssetBV\MailBundle\Entity\Mail;
use IssetBV\MailBundle\Entity\MailAddress;
use IssetBV\MailBundle\Service\Mail\AddressInterface;
use IssetBV\MailBundle\Service\Mail\Center\Mailer\MailChangeableInterface;
use IssetBV\MailBundle\Service\Mail\MailInterface;

class MailChangeable implements MailChangeableInterface
{
    /**
     * @var Mail
     */
    private $mail;
    /**
     * @var MailProxy
     */
    private $mailProxy;
    /**
     * @var MailAddressStateChanger
     */
    private $mailAddressStateChanger;

    public function __construct(MailAddressStateChanger $mailAddressStateChanger, Mail $mail)
    {
        $this->mail = $mail;
        $this->mailProxy = new MailProxy($mail);
        $this->mailAddressStateChanger = $mailAddressStateChanger;
    }

    public function getUUID(): string
    {
        return $this->mail->getUuid();
        // TODO: Implement getUUID() method.
    }

    public function getMail(): MailInterface
    {
        return $this->mailProxy;
    }

    public function changeState(AddressInterface $address, string $state)
    {
        if ($address instanceof MailAddress) {
            $this->mailAddressStateChanger->setState($address, $state);
        }
    }

    public function getMessageId(): string
    {
        return $this->mail->getMessageId();
    }
}
