<?php
declare(strict_types=1);

namespace IssetBV\MailBundle\Service\Mail;

use Doctrine\Common\Persistence\ObjectRepository;
use IssetBV\MailBundle\Entity\MailAddress;
use IssetBV\MailBundle\Entity\MailAddressState;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * Class MailStateChanger
 * @package IssetBV\MailBundle\Service\Mail
 */
class MailStateChanger
{

    /**
     * @var ObjectManager
     */
    private $manager;
    /**
     * @var ObjectRepository
     */
    private $mailAddressRepository;
    /**
     * @var ObjectRepository
     */
    private $mailAddressStateRepository;

    /**
     * MailStateChanger constructor.
     * @param RegistryInterface $registry
     */
    public function __construct(RegistryInterface $registry)
    {
        $this->manager = $registry->getManagerForClass(MailAddress::class);
        $this->mailAddressRepository = $registry->getRepository(MailAddress::class);
        $this->mailAddressStateRepository = $registry->getRepository(MailAddressState::class);
    }

    public function setPending(string $messageId, array $emails)
    {
        $mailAddresses = $this->mailAddressRepository->fetchByMessageIdAndEmails($messageId, $emails);
        $this->setStates($mailAddresses, $this->getMailAddressState(MailAddressState::PENDING));
        $this->manager->flush();
    }

    public function setFailed(string $messageId, array $emails)
    {
        $mailAddresses = $this->mailAddressRepository->fetchByMessageIdAndEmails($messageId, $emails);
        $this->setStates($mailAddresses, $this->getMailAddressState(MailAddressState::FAILED));
        $this->manager->flush();
    }

    public function setSent(string $messageId, array $emails)
    {
        $mailAddresses = $this->mailAddressRepository->fetchByMessageIdAndEmails($messageId, $emails);
        $this->setStates($mailAddresses, $this->getMailAddressState(MailAddressState::SENT));
        $this->manager->flush();

    }

    /**
     * @param MailAddress[] $mailAddresses
     * @param MailAddressState $state
     */
    public function setStates(array $mailAddresses, MailAddressState $state)
    {
        foreach ($mailAddresses as $mailAddress) {
            $this->setState($mailAddress, $state);
        }
    }

    /**
     * @param MailAddress $mailAddress
     * @param MailAddressState $state
     */
    public function setState(MailAddress $mailAddress, MailAddressState $state)
    {
        $mailAddress->setState($state);
    }

    /**
     * @param string $state
     * @return MailAddressState
     */
    public function getMailAddressState($state)
    {
        return $this->mailAddressStateRepository->find($state);
    }

}