<?php
declare(strict_types = 1);

namespace IssetBV\MailBundle\Fixture;

use ReflectionClass;
use Doctrine\ORM\EntityManagerInterface;
use IssetBV\FixtureBundle\Service\FixtureInterface;
use IssetBV\MailBundle\Entity\MailAddressState;

class MailAddressStateFixture implements FixtureInterface
{

    /**
     * @param EntityManagerInterface $entityManager
     * @return null|void
     */
    public function handle(EntityManagerInterface $entityManager)
    {
        $constants = (new ReflectionClass(MailAddressState::class))->getConstants();
        $repo = $entityManager->getRepository(MailAddressState::class);
        foreach ($constants as $constant) {
            if ($repo->findOneBy(['state' => $constant]) === null) {
                $new = new MailAddressState();
                $new->setState($constant);
                $entityManager->persist($new);
            }
        }
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return 'MailAddressState';
    }

    /**
     * @return int
     */
    public function getWeight(): int
    {
        return 500;
    }

    /**
     * @return array
     */
    public function getGroups(): array
    {
        return ['prod'];
    }
}