<?php

declare(strict_types = 1);

namespace IssetBV\MailBundle\Service\Mail;

use IssetBV\MailBundle\Service\Mail\Event\MailSpoolEvent;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use IssetBV\MailBundle\Entity\Mail as MailEntity;

/**
 * Class MailEventThrower.
 */
class MailEventThrower
{
    /**
     * @var EventDispatcherInterface
     */
    private $eventDispatcher;

    /**
     * MailEventThrower constructor.
     * @param EventDispatcherInterface $eventDispatcher
     */
    public function __construct(EventDispatcherInterface $eventDispatcher)
    {
        $this->eventDispatcher = $eventDispatcher;
    }

    /**
     * @param MailEntity $mail
     */
    public function throwSpoolEvent(MailEntity $mail)
    {
        $this->eventDispatcher->dispatch(MailSpoolEvent::NAME, new MailSpoolEvent($mail));
    }
}