<?php

declare(strict_types = 1);

namespace IssetBV\MailBundle\Service\Mail\Event;

use IssetBV\MailBundle\Entity\Mail;

/**
 * Class MailSpoolEvent.
 */
class MailSpoolEvent extends MailEvent
{
    const NAME = "isset_bv.mail.spool";
    /**
     * @var Mail
     */
    private $mail;

    /**
     * MailSentEvent constructor.
     * @param Mail $mail
     */
    public function __construct(Mail $mail)
    {
        $this->mail = $mail;
    }

    /**
     * @return Mail
     */
    public function getMail(): Mail
    {
        return $this->mail;
    }

}