<?php
declare(strict_types = 1);

namespace IssetBV\MailBundle\Service\Mail\Core;

/**
 * Interface Mail
 * @package IssetBV\MailBundle\Service\Mail\Core
 */
interface Mail
{

    /**
     * @param string $email
     * @param string $name
     */
    public function setFrom(string $email, string $name = null);

    /**
     * @return Address
     */
    public function getFrom(): Address;

    /**
     * @return Address[]
     */
    public function getTo(): array;

    /**
     * @return Address[]
     */
    public function getCc(): array;

    /**
     * @return Address[]
     */
    public function getBcc(): array;

    /**
     * @return Attachment[]
     */
    public function getAttachments(): array;

    /**
     * @return string
     */
    public function getSubject(): string;

    /**
     * @return string|null
     */
    public function getBodyHtml();

    /**
     * @return string|null
     */
    public function getBodyText();
}