<?php
declare(strict_types = 1);

namespace IssetBV\MailBundle\Fixture;

use Doctrine\ORM\EntityManagerInterface;
use IssetBV\FixtureBundle\Service\FixtureInterface;
use IssetBV\MailBundle\Entity\MailAddressType;
use ReflectionClass;

class MailAddressTypeFixture implements FixtureInterface
{

    /**
     * @param EntityManagerInterface $entityManager
     * @return null|void
     */
    public function handle(EntityManagerInterface $entityManager)
    {
        $constants = (new ReflectionClass(MailAddressType::class))->getConstants();
        $repo = $entityManager->getRepository(MailAddressType::class);
        foreach ($constants as $constant) {
            if ($repo->findOneBy(['type' => $constant]) === null) {
                $new = new MailAddressType();
                $new->setType($constant);
                $entityManager->persist($new);
            }
        }
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return 'MailAddressType';
    }

    /**
     * @return int
     */
    public function getWeight(): int
    {
        return 500;
    }

    /**
     * @return array
     */
    public function getGroups(): array
    {
        return ['prod'];
    }
}