<?php
declare(strict_types = 1);

namespace IssetBV\MailBundle\Service\Mail;

use IssetBV\MailBundle\Service\Mail\Core\Attachment as AttachmentCore;

class Attachment implements AttachmentCore
{

    /**
     * @var string
     */
    private $filePath;
    /**
     * @var string
     */
    private $name;

    /**
     * Attachment constructor.
     * @param string $filePath
     * @param string|null $name
     */
    public function __construct(string $filePath, string $name = null)
    {
        $this->filePath = $filePath;
        $this->name = $name;
    }

    public function getFilePath()
    {
        return $this->filePath;
    }

    public function getName()
    {
        return $this->name;
    }
}