<?php
declare(strict_types = 1);

namespace IssetBV\MailBundle\Service\Mail;

use IssetBV\MailBundle\Service\Mail\Core\Address as AddressInterface;

class Address implements AddressInterface
{

    /**
     * @var string
     */
    private $email;
    /**
     * @var string
     */
    private $name;

    /**
     * Address constructor.
     * @param string $email
     * @param string|null $name
     */
    public function __construct(string $email, string $name = null)
    {
        $this->email = $email;
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
}