<?php
declare(strict_types = 1);

namespace IssetBV\MailBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MailBundle\Entity\MailAddress;

class MailAddressRepository extends EntityRepository
{

    /**
     * @param string $messageId
     * @param array $emails
     * @return MailAddress
     */
    public function fetchByMessageIdAndEmails(string $messageId, array $emails)
    {
        $qb = $this->createQueryBuilder('mail_address');
        $qb->join('mail_address.mail', 'mail');
        $qb->where('mail.messageId = :messageId');
        $qb->andWhere('mail_address.email in(:emails)');
        $qb->setParameters([
            'messageId' => $messageId,
            'emails' => $emails
        ]);
        return $qb->getQuery()->getResult();
    }
}