<?php
declare(strict_types = 1);

namespace IssetBV\MailBundle\Service\Mail;

use IssetBV\MailBundle\Service\Mail\Core\Address;
use IssetBV\MailBundle\Service\Mail\Address as AddressDefault;
use IssetBV\MailBundle\Service\Mail\Core\Attachment as AttachmentCore;
use IssetBV\MailBundle\Service\Mail\Core\Mail as MailInterface;

class Mail implements MailInterface
{

    /**
     * @var Address
     */
    private $from;
    /**
     * @var Address[]
     */
    private $to = array();
    /**
     * @var Address[]
     */
    private $cc = array();
    /**
     * @var Address[]
     */
    private $bcc = array();
    /**
     * @var AttachmentCore[]
     */
    private $attachments = array();
    /**
     * @var string
     */
    private $subject;
    /**
     * @var string
     */
    private $bodyHtml;
    /**
     * @var string
     */
    private $bodyText;

    /**
     * @param string $email
     * @param string $name
     */
    public function setFrom(string $email, string $name = null)
    {
        $this->from = new AddressDefault($email, $name);
    }

    /**
     * @return Address
     */
    public function getFrom(): Address
    {
        return $this->from;
    }

    public function addTo(string $email, $name = null)
    {
        $this->to[] = new AddressDefault($email, $name);
    }

    /**
     * @return Address[]
     */
    public function getTo(): array
    {
        return $this->to;
    }

    public function addCc(string $email, $name = null)
    {
        $this->cc[] = new AddressDefault($email, $name);
    }

    /**
     * @return Address[]
     */
    public function getCc(): array
    {
        return $this->cc;
    }

    public function addBcc(string $email, $name = null)
    {
        $this->bcc[] = new AddressDefault($email, $name);
    }

    /**
     * @return Address[]
     */
    public function getBcc(): array
    {
        return $this->bcc;
    }

    /**
     * @param string $subject
     */
    public function setSubject(string $subject)
    {
        $this->subject = $subject;
    }

    /**
     * @return string
     */
    public function getSubject(): string
    {
        return $this->subject;
    }

    /**
     * @param string $bodyHtml
     */
    public function setBodyHtml(string $bodyHtml)
    {
        $this->bodyHtml = $bodyHtml;
    }

    /**
     * @return string|null
     */
    public function getBodyHtml()
    {
        return $this->bodyHtml;
    }

    /**
     * @param string $bodyText
     */
    public function setBodyText(string $bodyText)
    {
        $this->bodyText = $bodyText;
    }

    /**
     * @return string|null
     */
    public function getBodyText()
    {
        return $this->bodyText;
    }

    /**
     * @return AttachmentCore[]
     */
    public function getAttachments(): array
    {
        return $this->attachments;
    }

    public function addAttachment(string $filePath, string $fileName = null)
    {
        $this->attachments[] = new Attachment($filePath, $fileName);
    }
}