<?php
declare(strict_types = 1);

namespace IssetBV\MailBundle\Service\Mail;

use Doctrine\Bundle\DoctrineBundle\Registry;
use Doctrine\Common\Persistence\ObjectRepository;
use IssetBV\MailBundle\Entity\Mail as MailEntity;
use IssetBV\MailBundle\Entity\MailAddress;
use IssetBV\MailBundle\Entity\MailAddressState;
use IssetBV\MailBundle\Entity\MailAddressType;
use IssetBV\MailBundle\Service\Mail\Core\Address;
use IssetBV\MailBundle\Service\Mail\Core\Mail as MailInterface;

/**
 * Class MailToEntityConverter
 * @package IssetBV\MailBundle\Service\Mail
 */
class MailToEntityConverter
{

    /**
     * @var ObjectRepository
     */
    private $mailAddressStateRepository;
    /**
     * @var ObjectRepository
     */
    private $mailAddressTypeRepository;

    /**
     * MailToEntityConverter constructor.
     * @param Registry $registry
     */
    public function __construct(Registry $registry)
    {
        $this->mailAddressStateRepository = $registry->getRepository(MailAddressState::class);
        $this->mailAddressTypeRepository = $registry->getRepository(MailAddressType::class);
    }

    /**
     * @param MailInterface $mail
     * @return MailEntity
     */
    public function convert(MailInterface $mail): MailEntity
    {
        $mailEntity = new MailEntity();
        $mailEntity->setBody($mail->getBodyText());
        $mailEntity->setBodyHtml($mail->getBodyHtml());
        $mailEntity->setFrom($mail->getFrom()->getEmail());
        $mailEntity->setFromName($mail->getFrom()->getName());

        $this->convertAddresses($mail->getTo(), $mailEntity, $this->mailAddressTypeRepository->find(MailAddressType::TO));
        $this->convertAddresses($mail->getBcc(), $mailEntity, $this->mailAddressTypeRepository->find(MailAddressType::BCC));
        $this->convertAddresses($mail->getCc(), $mailEntity, $this->mailAddressTypeRepository->find(MailAddressType::CC));
        return $mailEntity;
    }

    /**
     * @param Address[] $addresses
     * @param MailEntity $mailEntity
     * @param MailAddressType $type
     */
    private function convertAddresses(array $addresses, MailEntity $mailEntity, MailAddressType $type)
    {
        $pending = $this->mailAddressStateRepository->find(MailAddressState::PENDING);
        foreach ($addresses as $address) {
            $mailAddress = new MailAddress();
            $mailAddress->setType($type);
            $mailAddress->setEmail($address->getEmail());
            $mailAddress->setName($address->getName());
            $mailAddress->setState($pending);
            $mailEntity->addAddress($mailAddress);
        }
    }

}