<?php
declare(strict_types = 1);

namespace IssetBV\MailBundle\Service\Mail;

use Doctrine\Common\Persistence\ObjectRepository;
use IssetBV\MailBundle\Entity\MailAddress;
use IssetBV\MailBundle\Entity\MailAddressState;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * Class MailStateChanger
 * @package IssetBV\MailBundle\Service\Mail
 */
class MailStateChanger
{

    /**
     * @var ObjectManager
     */
    private $manager;
    /**
     * @var ObjectRepository
     */
    private $mailAddressRepository;
    /**
     * @var ObjectRepository
     */
    private $mailAddressStateRepository;

    /**
     * MailStateChanger constructor.
     * @param RegistryInterface $registry
     */
    public function __construct(RegistryInterface $registry)
    {
        $this->manager = $registry->getManagerForClass(MailAddress::class);
        $this->mailAddressRepository = $registry->getRepository(MailAddress::class);
        $this->mailAddressStateRepository = $registry->getRepository(MailAddressState::class);
    }

    public function setPending(string $messageId, array $emails)
    {
        $mailAddresses = $this->mailAddressRepository->fetchByMessageIdAndEmails($messageId, $emails);
        $this->setState($mailAddresses, $this->mailAddressStateRepository->find(MailAddressState::PENDING));
        $this->manager->flush();
    }

    public function setFailed(string $messageId, array $emails)
    {
        $mailAddresses = $this->mailAddressRepository->fetchByMessageIdAndEmails($messageId, $emails);
        $this->setState($mailAddresses, $this->mailAddressStateRepository->find(MailAddressState::FAILED));
        $this->manager->flush();
    }

    public function setSent(string $messageId, array $emails)
    {
        $mailAddresses = $this->mailAddressRepository->fetchByMessageIdAndEmails($messageId, $emails);
        $this->setState($mailAddresses, $this->mailAddressStateRepository->find(MailAddressState::SENT));
        $this->manager->flush();
    }

    /**
     * @param MailAddress[] $mailAddresses
     * @param MailAddressState $state
     */
    private function setState(array $mailAddresses, MailAddressState $state)
    {
        foreach ($mailAddresses as $mailAddress) {
            $mailAddress->setState($state);
        }
    }
}