<?php
declare(strict_types = 1);

namespace IssetBV\MailBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="isset_bv_mail_address_states")
 */
class MailAddressState
{

    CONST PENDING = 'pending';
    CONST SENT = 'sent';
    CONST FAILED = 'failed';

    /**
     * @var string
     * @ORM\Id
     * @ORM\Column(type="string")
     */
    private $state;

    /**
     * @return string
     */
    public function getState(): string
    {
        return $this->state;
    }

    /**
     * @param string $state
     */
    public function setState(string $state)
    {
        $this->state = $state;
    }

}