<?php
declare(strict_types = 1);

namespace IssetBV\MailBundle\Entity;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="isset_bv_mails")
 */
class Mail
{

    /**
     * @var int
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;
    /**
     * @var MailAddress[]|ArrayCollection
     * @ORM\OneToMany(targetEntity="MailAddress", mappedBy="mail", cascade={"persist"})
     */
    private $addresses;
    /**
     * @var MailAttachment[]|ArrayCollection
     * @ORM\OneToMany(targetEntity="MailAttachment", mappedBy="mail", cascade={"persist"})
     */
    private $attachments;
    /**
     * @var string
     * @ORM\Column(name="from_email", type="string", nullable=false)
     */
    private $from;
    /**
     * @var string
     * @ORM\Column( type="string", nullable=true)
     */
    private $fromName;
    /**
     * @var string
     * @ORM\Column(name="message_id", type="string", nullable=false)
     */
    private $messageId;
    /**
     * @var string
     * @ORM\Column(type="text", nullable=true)
     */
    private $body;
    /**
     * @var string
     * @ORM\Column(type="text", nullable=true)
     */
    private $bodyHtml;
    /**
     * @var DateTime
     * @ORM\Column( type="datetime", nullable=false)
     */
    private $created;

    /**
     * Mail constructor.
     */
    public function __construct()
    {
        $this->created = new DateTime();
        $this->addresses = new ArrayCollection();
        $this->attachments = new ArrayCollection();
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return ArrayCollection|MailAddress[]
     */
    public function getAddresses()
    {
        return $this->addresses;
    }

    /**
     * @param MailAddress $mailAddress
     */
    public function addAddress(MailAddress $mailAddress)
    {
        $mailAddress->setMail($this);
        $this->addresses->add($mailAddress);
    }

    /**
     * @return ArrayCollection|MailAttachment[]
     */
    public function getAttachments()
    {
        return $this->attachments;
    }

    /**
     * @return string
     */
    public function getMessageId(): string
    {
        return $this->messageId;
    }

    /**
     * @param string $messageId
     */
    public function setMessageId(string $messageId)
    {
        $this->messageId = $messageId;
    }

    /**
     * @return string
     */
    public function getFrom(): string
    {
        return $this->from;
    }

    /**
     * @param string $from
     */
    public function setFrom(string $from)
    {
        $this->from = $from;
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return $this->fromName;
    }

    /**
     * @param string $fromName
     */
    public function setFromName(string $fromName = null)
    {
        $this->fromName = $fromName;
    }

    /**
     * @return string
     */
    public function getBody()
    {
        return $this->body;
    }

    /**
     * @param string $body
     */
    public function setBody(string $body = null)
    {
        $this->body = $body;
    }

    /**
     * @return string
     */
    public function getBodyHtml()
    {
        return $this->bodyHtml;
    }

    /**
     * @param string $bodyHtml
     */
    public function setBodyHtml(string $bodyHtml = null)
    {
        $this->bodyHtml = $bodyHtml;
    }

    /**
     * @return DateTime
     */
    public function getCreated(): DateTime
    {
        return $this->created;
    }

}