<?php

declare(strict_types=1);

namespace IssetBV\LogBundle\Log\Processor;

class GitProcessor implements ProcessorInterface
{
    /**
     * @var string
     */
    private $gitHah;

    public function __construct(string $gitHah)
    {
        $this->gitHah = $gitHah;
    }

    public function processRecord(array $record): array
    {
        $record['extra']['git_hash'] = $this->gitHah;

        return $record;
    }
}
