<?php

declare(strict_types=1);

namespace IssetBV\LogBundle\DependencyInjection;

use IssetBV\LogBundle\DependencyInjection\Compiler\LoggerAwareCompilerPass;
use IssetBV\LogBundle\Log\Processor\FieldsLogProcessor;
use IssetBV\LogBundle\Log\Processor\GitProcessor;
use IssetBV\LogBundle\Log\Processor\ProcessorInterface;
use IssetBV\LogBundle\Log\Processor\RouteLogProcessor;
use IssetBV\LogBundle\Log\Processor\Session\SessionIdentifierProcessor;
use Psr\Log\LoggerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\HttpKernel\Kernel;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVLogExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        if (array_key_exists('fields', $config) || array_key_exists('const', $config)) {
            $fieldLogProcessor = $container->register(
                FieldsLogProcessor::class
            );
            $fieldLogProcessor->addArgument($config['fields'] ?? []);
            $fieldLogProcessor->addArgument($config['const'] ?? []);
            $fieldLogProcessor->addTag('monolog.processor', ['method' => 'processRecord']);
        }

        if (array_key_exists('route', $config)) {
            $fieldLogProcessor = $container->register(
                RouteLogProcessor::class
            );
            $fieldLogProcessor->addArgument($config['route']);
            $fieldLogProcessor->addTag('monolog.processor', ['method' => 'processRecord']);
            $fieldLogProcessor->addMethodCall('setRequest', [new Reference('request_stack')]);
        }

        if (array_key_exists('session_identifier', $config)) {
            $fieldLogProcessor = $container->register(
                SessionIdentifierProcessor::class
            );
            $fieldLogProcessor->addTag('monolog.processor', ['method' => 'processRecord']);
        }

        if (array_key_exists('git', $config)) {
            $command = sprintf(
                'cd %s && %s log --pretty="%%H" -n1 HEAD',
                $container->getParameter('kernel.root_dir'),
                $config['git']['exec']
            );
            $hash = exec($command);

            $gitProcessor = $container->register(
                GitProcessor::class
            );
            $gitProcessor->addArgument($hash);
            $gitProcessor->addTag('monolog.processor', ['method' => 'processRecord']);
        }

        if (Kernel::MAJOR_VERSION > 3 || (Kernel::MAJOR_VERSION === 3 && Kernel::MINOR_VERSION >= 3)) {
            $container
                ->registerForAutoconfiguration(ProcessorInterface::class)
                ->addTag('monolog.processor', ['method' => 'processRecord']);
            if ($config['logger_aware_auto_tag']) {
                $container
                    ->registerForAutoconfiguration(LoggerAwareInterface::class)
                    ->addTag(LoggerAwareCompilerPass::TAG);
            }
        }
    }
}
