<?php

declare(strict_types=1);

namespace IssetBV\LogBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class LoggerAwareCompilerPass implements CompilerPassInterface
{
    const TAG = 'logbundle_logger_aware';

    /**
     * {@inheritdoc}
     *
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     */
    public function process(ContainerBuilder $container)
    {
        $taggedServices = $container->findTaggedServiceIds(self::TAG);
        foreach (array_keys($taggedServices) as $id) {
            $definition = $container->getDefinition($id);
            $definition->addMethodCall('setLogger', [
                new Reference('logger'),
            ]);
        }
    }
}
