<?php

declare(strict_types=1);

namespace IssetBV\LogBundle\Log\Processor;

class FieldsLogProcessor implements ProcessorInterface
{
    /**
     * @var array
     */
    private $fields;
    /**
     * @var array
     */
    private $const;

    public function __construct(array $fields, array $const)
    {
        $this->fields = $fields;
        $this->const = $const;
    }

    public function processRecord(array $record): array
    {
        foreach ($this->fields as $fieldName => $fieldValue) {
            $record['extra'][$fieldName] = $fieldValue;
        }

        if (0 === \count($this->const)) {
            return $record;
        }

        foreach ($this->const as $constName => $constValue) {
            $record['extra'][$constName] = \defined($constValue) ? \constant($constValue) : null;
        }

        return $record;
    }
}
