<?php

declare(strict_types=1);

namespace IssetBV\LogBundle;

use IssetBV\LogBundle\Log\Processor\ProcessorInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;
use Symfony\Component\HttpKernel\Kernel;

class IssetBVLogBundle extends Bundle
{
    /**
     * @param ContainerBuilder $container
     */
    public function build(ContainerBuilder $container)
    {
        parent::build($container);

        if (Kernel::MAJOR_VERSION > 3 || (Kernel::MAJOR_VERSION === 3 && Kernel::MINOR_VERSION >= 3)) {
            $container
                ->registerForAutoconfiguration(ProcessorInterface::class)
                ->addTag(' monolog.processor', ['method' => 'processRecord']);
        }
    }
}
