<?php

declare(strict_types=1);

namespace IssetBV\LogBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('isset_bv_log');

        $rootNode
            ->children()
            ->arrayNode('fields')
            ->requiresAtLeastOneElement()
            ->useAttributeAsKey('name')->prototype('scalar')->end()
            ->end()
            ->end();

        $rootNode
            ->children()
            ->arrayNode('const')
            ->requiresAtLeastOneElement()
            ->useAttributeAsKey('name')->prototype('scalar')->end()
            ->end()
            ->end();

        $rootNode
            ->children()
            ->arrayNode('route')
            ->children()
            ->scalarNode('method')->defaultTrue()->end()
            ->scalarNode('route')->defaultTrue()->end()
            ->scalarNode('route_path')->defaultTrue()->end()
            ->scalarNode('headers')->defaultFalse()->end()
            ->scalarNode('request')->defaultFalse()->end()
            ->scalarNode('query')->defaultFalse()->end()
            ->scalarNode('cookies')->defaultFalse()->end()
            ->end()
            ->end()
            ->end();

        return $treeBuilder;
    }
}
