<?php

declare(strict_types=1);

namespace IssetBV\LogBundle\DependencyInjection;

use IssetBV\LogBundle\Log\Processor\FieldsLogProcessor;
use IssetBV\LogBundle\Log\Processor\RouteLogProcessor;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVLogExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        if (array_key_exists('fields', $config)) {
            $fieldLogProcessor = $container->register(
                FieldsLogProcessor::class
            );
            $fieldLogProcessor->addArgument($config['fields']);
            $fieldLogProcessor->addTag('monolog.processor', ['method' => 'processRecord']);
        }

        if (array_key_exists('route', $config)) {
            $fieldLogProcessor = $container->register(
                RouteLogProcessor::class
            );
            $fieldLogProcessor->addArgument($config['route']);
            $fieldLogProcessor->addTag('monolog.processor', ['method' => 'processRecord']);
            $fieldLogProcessor->addMethodCall('setRequest', [new Reference('request_stack')]);
        }
    }
}
