<?php

declare(strict_types=1);

namespace IssetBV\LogBundle\Log\Processor;

class FieldsLogProcessor
{

    /**
     * @var array
     */
    private $fields;

    public function __construct(array $fields)
    {
        $this->fields = $fields;
    }

    public function processRecord(array $record): array
    {
        foreach ($this->fields as $fieldName => $fieldValue) {
            $record['extra'][$fieldName] = $fieldValue;
        }

        return $record;
    }
}
