(function() {
    'use strict';

    var jobRemotesController = function($rootScope, $http) {
        var vm = this;

        vm.setRemote = setRemote;
        vm.browseRemote = browseRemote;
        vm.browse = browse;
        vm.addDirectory = addDirectory;
        vm.selectDownload = selectDownload;
        vm.selectPublisher = selectPublisher;

        function selectDownload() {
            vm.remote = {id: 'download', name: 'Download', type: 'download'};
        }

        function selectPublisher() {
            vm.remote = {id: 'publisher', name: 'Publisher', type: 'publisher'};
        }

        function setRemote(remote) {
            vm.remote = angular.copy(remote);
        }

        function browseRemote(remote, path) {
            if (remote) {
                switch (remote.type) {
                    case 'archive':
                        vm.browse('isset_bv_hatchery_application_job_builder_browse_archive', remote, path);
                        break;
                    case 'upload':
                        vm.browse('isset_bv_hatchery_application_job_builder_browse_uploads', remote, path);
                        break;
                    case 'youtube':
                    case 'download':
                    case 'publisher':
                        $rootScope.$broadcast('remote:updated');
                        break;
                    default:
                        vm.browse('isset_bv_hatchery_application_job_builder_browse_remote', remote, path);
                        break;
                }
            }
        }

        function browse(endPoint, remote, path) {
            remote.error = false;
            remote.loading = true;

            $http.get(Routing.generate(endPoint, {
                remoteIdentifier: remote.id,
                directory: path
            })).then(function (result) {
                remote.loading = false;
                remote.data = result.data;
                $rootScope.$broadcast('remote:updated');
            }, function () {
                remote.loading = false;
                remote.error = true;
                remote.remote = null;
            });
        }

        function addDirectory(remote, folder) {

            if (!folder)  return;

            remote.loading = true;

            var newDirectory;
            if (remote.data.directory === "") {
                newDirectory = folder;
            } else {
                newDirectory = remote.data.directory + folder;
            }

            if (remote.type === 'archive') {
                if (remote.data.directory.length > 0) {
                    var postData = $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_add_archive_directory'), {
                        folder: folder,
                        parent: remote.data.directory
                    });

                    postData.then(function (result) {
                        newDirectory = result.data.uuid;
                        vm.browseRemote(remote, newDirectory);
                    }, function () {
                        remote.loading = false;
                        remote.error = true;
                    });
                }
            } else {
                vm.browseRemote(remote, newDirectory);
            }
        }

    };

    angular
        .module('jobRemotes')
        .controller('jobRemotesController', [
            '$rootScope',
            '$http',
            jobRemotesController
        ]);
})();